//%attributes = {}
// Method: fl_ AREA_DRAW 
// 02.12.09, 21:08:09 / PM
// © Copyright Manage Applications
// Purpose: 
// see: ldmp_AREA_DRAW
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $2; $fl_lPage; $fl_lDrawArrow)
C_TEXT:C284($fl_tObject; $fl_tImage)  //$fl_tGroup
C_TEXT:C284($fl_tFilePath; $fl_tHighlightColor; $fl_tTxt; $fl_tFont; $fl_tBarBorderColor; $fl_tBarColor)

C_LONGINT:C283($fl_lSvgOptions; $fl_lIndex; $fl_lColIndex; $fl_lColCount; $fl_lRowIndex; $fl_lRowCount)
C_LONGINT:C283($fl_lAreaWidth; $fl_lAreaHeigth; $fl_lEnd)
C_LONGINT:C283($fl_lPosWidth; $fl_lPosHeigth)
C_LONGINT:C283($fl_lColums; $fl_lX; $fl_lX2; $fl_lWidth; $fl_lHeigth)

C_LONGINT:C283($fl_lCellFullLoadLine; $fl_lCellFullLoadLineGap; $fl_lCellBarLeft1; $fl_lCellBarLeft2; $fl_lCellBarWidth; $fl_lBarTop)
C_LONGINT:C283($fl_lBarHeigth; $fl_lPixels)
C_LONGINT:C283($fl_lRowCount; $fl_lRowStart; $fl_lRowEnd)

C_REAL:C285($fl_rCellFullLoadPercent; $fl_rCellBarLeftPercent)
C_REAL:C285($fl_rCellBarWidthPercent; $fl_rCellBarGapPercent; $fl_rCellFullLoadGapPercent)

C_REAL:C285($fl_rY; $fl_rBorderWidth; $fl_rTxtFromBorder; $fl_rFontSize; $fl_rCircleAreaWidth)
C_REAL:C285($fl_rArrowSize; $fl_rTextRightMove; $fl_rTextDownMove; $fl_rArrowRightMove; $fl_rArrowDownMove)
C_REAL:C285($fl_rHighlightLineWidth)

C_PICTURE:C286($fl_gArrowRight; $fl_gArrowDown)

SET CURSOR:C469(kCursorWatch)
COMPILER_fl_
fl_ SVG_CLEAR

If (Count parameters:C259>0)
	$fl_lPage:=$1
Else 
	$fl_lPage:=FORM Get current page:C276
End if 
If (Count parameters:C259>1)
	$fl_lDrawArrow:=$2
Else 
	$fl_lDrawArrow:=kTrue
End if 


$fl_tFont:=_fi IncludeFontName
$fl_rFontSize:=_fi DialogFontSize
$fl_rArrowSize:=12
$fl_rTextRightMove:=0
$fl_rTextDownMove:=0
$fl_rArrowRightMove:=0
$fl_rArrowDownMove:=0

_prf_ JSON(fl_tJsonPrfName; "RowTextFont"; ->$fl_tFont)
_prf_ JSON(fl_tJsonPrfName; "RowTextFontSize"; ->$fl_rFontSize)
_prf_ JSON(fl_tJsonPrfName; "RowArrowSize"; ->$fl_rArrowSize)
_prf_ JSON(fl_tJsonPrfName; "RowTextRightMove"; ->$fl_rTextRightMove)
_prf_ JSON(fl_tJsonPrfName; "RowTextDownMove"; ->$fl_rTextDownMove)
_prf_ JSON(fl_tJsonPrfName; "RowArrowRightMove"; ->$fl_rArrowRightMove)
_prf_ JSON(fl_tJsonPrfName; "RowArrowDownMove"; ->$fl_rArrowDownMove)

$fl_tHighlightColor:="black"
$fl_rHighlightLineWidth:=2
//$fl_rHighlightGapHorizontal:=1  // in fl_ ON_AREA
//$fl_rHighlightGapVertical:=1
_prf_ JSON(fl_tJsonPrfName; "HighlightColor"; ->$fl_tHighlightColor)
_prf_ JSON(fl_tJsonPrfName; "HighlightLineWidth"; ->$fl_rHighlightLineWidth)
//_prf_ JSON (fl_tJsonPrfName;"HighlightGapHorizontal";->$fl_rHighlightGapHorizontal)
//_prf_ JSON (fl_tJsonPrfName;"HighlightGapVertical";->$fl_rHighlightGapVertical)

If (fl_lDailyLoad=2)
	$fl_rCircleAreaWidth:=38
Else 
	$fl_rCircleAreaWidth:=0
End if 
_prf_ JSON(fl_tJsonPrfName; "CircleAreaWidth"; ->$fl_rCircleAreaWidth)

lf_cap_INFO_ALL_ARR(kInit)


If (fl_lDailyLoad=2)  // only 1 day in view
	ldmp_ AREA_VARIABLE_SET($fl_lPage)
End if 
//If ((fl_lObjectX=0) & (fl_lObjectY=0))
_var_ OBJECT_LEFT_TOP_GET(fl_pSvgArea; ->fl_lObjectX; ->fl_lObjectY)
//End if 

ARRAY LONGINT:C221(fl_alSelected; 0)  // ok here
_arr CLEAR(0; ->fl_alSubHeigth)

// fl subarea
fl_ TIME_HEADERS_DRAW_SET(fl_lDrawTimeHeaders)

_var_ OBJECT_SIZE_GET(fl_pSvgArea; ->$fl_lWidth; ->$fl_lHeigth)

Case of 
	: (fl_lUseWindowWidth=2)
		$fl_lWidth:=<>fl_lGraphWidth
	: (fl_lUseWindowWidth=kTrue)
		C_LONGINT:C283($fl_lLeft; $fl_lTop; $fl_lRight; $fl_lBottom)
		GET WINDOW RECT:C443($fl_lLeft; $fl_lTop; $fl_lRight; $fl_lBottom)
		$fl_lWidth:=$fl_lRight-$fl_lLeft
End case 

If (fl_lDailyLoad=2)  // only 1 day in view
	If ($fl_lWidth>300)
		If ($fl_lPage=2)  // FORM Get current page is no effective until after redraw
			fl_lCellWidth:=$fl_lWidth-fl_lHeaderWidth-6  // space for scrollbar = -16, -6 for exrta space min. needed
		Else 
			fl_lCellWidth:=$fl_lWidth-fl_lHeaderWidth-16-6  // space for scrollbar = -16, -6 for exrta space min. needed
		End if 
		fl_lCellWidth:=fl_lCellWidth-$fl_rCircleAreaWidth
	End if 
End if 

C_LONGINT:C283($fl_pb_lRoundedX; $fl_pb_lRoundedY)
$fl_pb_lRoundedX:=fl_pb_lRoundedX
$fl_pb_lRoundedY:=fl_pb_lRoundedY
fl_dCurrentDate:=_date Current(kTrue)
fl_hCurrentTime:=_time Current(kTrue)
fl_rCurrentDateTimeLocal:=_dt CurrentToReal(kFalse)  // local machine time call


If (fl_lDailyLoad>=1)
	$fl_lColums:=Size of array:C274(ldro_adDate)  //set in: ld_ro_MX_INIT
Else 
	$fl_lColums:=Size of array:C274(ldro_alWeek)  //set in: ld_ro_MX_INIT    
End if 
If ($fl_lColums<1)
	fl_dStartDate:=fl_dCurrentDate
	fl_dEndDate:=fl_dStartDate
Else 
	If (fl_lDailyLoad>=1)
		fl_dStartDate:=ldro_adDate{1}
		fl_dEndDate:=ldro_adDate{$fl_lColums}
	Else 
		fl_dStartDate:=_week_ ToWeekStartDate(ldro_alWeek{1})
		fl_dEndDate:=_week_ ToWeekEndDate(ldro_alWeek{$fl_lColums})
	End if 
End if 

$fl_lColCount:=ldro_lColumns
$fl_lRowStart:=1
$fl_lRowCount:=ldro_lRows
$fl_lRowEnd:=$fl_lRowCount
If (fl_lDailyLoad=2)
	$fl_lRowStart:=Find in array:C230(fl_afRowOpen; True:C214)
	If ($fl_lRowStart>0)
		$fl_lRowEnd:=$fl_lRowStart
		$fl_lRowCount:=1
	Else 
		$fl_lRowStart:=1
	End if 
	
End if 

$fl_rBorderWidth:=0.5
$fl_rTxtFromBorder:=3

$fl_rOpenedHeigth:=1000
$fl_lAreaWidth:=($fl_lColCount*fl_lCellWidth)+fl_lHeaderWidth
$fl_lAreaHeigth:=($fl_lRowCount*fl_lCellHeigth)+fl_lHeaderHeigth

// COMPILER__svg_ 
If (fl_tDrawRef#"")
	SVG_CLEAR(fl_tDrawRef)
End if 

fl_DEFAULT_STYLE_SET
fl_tDrawRef:=SVG_New($fl_lAreaWidth+2)  //;$fl_lAreaHeigth+2+$fl_rOpenedHeigth;"Matrix";"Matrix";True;Truncated non Centered)

// draw background color
$fl_tObject:=SVG_New_rect(fl_tDrawRef; 0; 0; $fl_lAreaWidth+$fl_rCircleAreaWidth+2; 90000; 0; 0; "none"; fl_pb_tBackgroundColorNone; 0)

If (fl_lDailyLoad=2)
	fl_START_STOP_CAP_DRAW_PRF
End if 

// used in fl_cap_ PAINT to show capacity (actual work) error/unknown phase rect patterns
//$fl_tImage:=SVG_Define_pattern (fl_tDrawRef;"PatternUnknownPhase";3;3;0;0) //;"";"0 0 4 4")
//$fl_tImage:=SVG_New_rect ($fl_tImage;0;0;3;3;0;0;"white";"blue")
//$fl_tImage:=SVG_Define_pattern (fl_tDrawRef;"PatternErrorPhase";4;4;0;0)
//$fl_tImage:=SVG_New_rect ($fl_tImage;0;0;4;4;0;0;"black";"red")

// define all gradients fow actual work, see fl_ACTUAL_WORK_TO_FL_CAP_ARR

C_TEXT:C284($fl_tGradientColorErrorPhase; $fl_tGradientColorUnknownPhase)
C_LONGINT:C283($fl_lWorkShiftCount; $fl_lGradientColorAngle)
$fl_tGradientColorErrorPhase:="gray:50"
$fl_tGradientColorUnknownPhase:="white:50"
$fl_lGradientColorAngle:=90
$fl_lWorkShiftCount:=4
_prf_ JSON(fl_tJsonPrfName; "GradientColorErrorPhase"; ->$fl_tGradientColorErrorPhase)
_prf_ JSON(fl_tJsonPrfName; "GradientColorUnknownPhase"; ->$fl_tGradientColorUnknownPhase)
_prf_ JSON(fl_tJsonPrfName; "GradientColorAngle"; ->$fl_lGradientColorAngle)
_prf_ JSON(fl_tJsonPrfName; "WorkShiftCount"; ->$fl_lWorkShiftCount)

$fl_tObject:=ldcap_ InfoToBrushColor(1; "ldcap_InfoToBrushColor"; ld_kTypeUnProductive)
If ($fl_tObject#"")
	$fl_tImage:=SVG_Define_linear_gradient(fl_tDrawRef; "PatternErrorPhase_"+Replace string:C233($fl_tObject; ":"; "_"); $fl_tObject; $fl_tGradientColorErrorPhase; $fl_lGradientColorAngle)
	$fl_tImage:=SVG_Define_linear_gradient(fl_tDrawRef; "PatternUnknownPhase_"+Replace string:C233($fl_tObject; ":"; "_"); $fl_tObject; $fl_tGradientColorUnknownPhase; $fl_lGradientColorAngle)
	For ($fl_lIndex; -1; $fl_lWorkShiftCount)
		$fl_tObject:=ldcap_ InfoToBrushColor(1; "ldcap_InfoToBrushColor"; String:C10($fl_lIndex))
		$fl_tImage:=SVG_Define_linear_gradient(fl_tDrawRef; "PatternErrorPhase_"+Replace string:C233($fl_tObject; ":"; "_"); $fl_tObject; $fl_tGradientColorErrorPhase; $fl_lGradientColorAngle)
		$fl_tImage:=SVG_Define_linear_gradient(fl_tDrawRef; "PatternUnknownPhase_"+Replace string:C233($fl_tObject; ":"; "_"); $fl_tObject; $fl_tGradientColorUnknownPhase; $fl_lGradientColorAngle)
	End for 
End if 
// create row arrow template
$fl_tImage:=SVG_Define_symbol(fl_tDrawRef; "fl_arrow")
$fl_tObject:=SVG_New_regular_polygon($fl_tImage; $fl_rArrowSize; 3; 0; 0; "none"; "rgb(152,152,152)"; 0)  // silver, darker but almost same as lightgrey, grey is too dark, 152,152,152 would be good

If ((fl_lHeaderHeigth>0) & (fl_lHeaderWidth>0))
	//draw white box on left upper corner
	$fl_tObject:=SVG_New_textArea(fl_tDrawRef; ""; 0; 0; fl_lHeaderWidth; fl_lHeaderHeigth; $fl_tFont; $fl_rFontSize)  //{;style{;alignment}}}}}}}})->Function result
	$fl_tTxt:="col_0"
	SVG_SET_ID($fl_tObject; $fl_tTxt)
End if 

$fl_rBorderWidth:=0.5
$fl_lPosWidth:=fl_lHeaderWidth
$fl_lPosHeigth:=0

_arr CLEAR(0; ->ldro_asID)
$fl_lEnd:=fl_lCellHeigth*$fl_lRowCount+fl_lHeaderHeigth+$fl_rOpenedHeigth

// draw column headers
For ($fl_lColIndex; 1; $fl_lColCount)
	If (fl_lHeaderHeigth>0)
		$fl_lX:=$fl_lPosWidth+$fl_rTxtFromBorder
		$fl_rY:=$fl_lPosHeigth+$fl_rTxtFromBorder
		$fl_tObject:=SVG_New_textArea(fl_tDrawRef; ldro_asColumnTitle{$fl_lColIndex}; $fl_lX; $fl_rY; fl_lCellWidth; fl_lHeaderHeigth; $fl_tFont; $fl_rFontSize)  //{;style{;alignment}}}}}}}})->Function result
		
		If (fl_lDailyLoad>=1)
			If (Size of array:C274(ldro_adDate)>=$fl_lColIndex)
				If ((Day number:C114(ldro_adDate{$fl_lColIndex})=Saturday:K10:18) | (Day number:C114(ldro_adDate{$fl_lColIndex})=Sunday:K10:19))
					SVG_SET_FONT_COLOR($fl_tObject; "grey")
				End if 
			Else 
				//?
			End if 
		End if 
		$fl_tTxt:="col_"+String:C10($fl_lColIndex)
		SVG_SET_ID($fl_tObject; $fl_tTxt)
	End if 
	
	$fl_lPosWidth:=$fl_lPosWidth+fl_lCellWidth
	$fl_lX:=fl_lCellWidth*$fl_lRowCount
	// one long vertical line from area top to bottom
	If ($fl_lColCount>1)
		$fl_tObject:=SVG_New_line(fl_tDrawRef; $fl_lPosWidth; $fl_lPosHeigth; $fl_lPosWidth; $fl_lEnd; "black"; $fl_rBorderWidth)
	End if 
	
End for 
// draw column headers - end

$fl_rBorderWidth:=0.5
$fl_lPosWidth:=0
$fl_lPosHeigth:=fl_lHeaderHeigth
$fl_lEnd:=fl_lCellWidth*$fl_lColCount+fl_lHeaderWidth

fl_ DRAW_CACHE_CLEAR

If (fl_lDailyLoad=2)
	ARRAY TEXT:C222(fl_atCurrentLoadGroup; 0)
	ARRAY TEXT:C222(fl_atCurrentProdLotPhase; 0)
	ARRAY LONGINT:C221(fl_alNumberOfOpenPhase; 0)
	For ($fl_lRowIndex; $fl_lRowStart; $fl_lRowEnd)
		APPEND TO ARRAY:C911(fl_atCurrentLoadGroup; ldro_atLGLoadCodes{$fl_lRowIndex})
	End for 
	ldmp_CURRENT_VALUES_TO_ARR(->fl_atCurrentLoadGroup; ->fl_atCurrentProdLotPhase; ->fl_alNumberOfOpenPhase)
End if 

For ($fl_lRowIndex; $fl_lRowStart; $fl_lRowEnd)
	If (fl_lHeaderWidth>0)
		// draw row headers
		$fl_lX:=$fl_lPosWidth+$fl_rTxtFromBorder+$fl_rTextRightMove
		$fl_rY:=$fl_lPosHeigth+$fl_rTxtFromBorder+$fl_rTextDownMove
		$fl_tObject:=SVG_New_textArea(fl_tDrawRef; ldro_asRowTitle{$fl_lRowIndex}; $fl_lX; $fl_rY; fl_lHeaderWidth; fl_lCellHeigth; $fl_tFont; $fl_rFontSize)  //{;style{;alignment}}}}}}}})->Function result
		$fl_tTxt:="row_"+String:C10($fl_lRowIndex)
		SVG_SET_ID($fl_tObject; $fl_tTxt)
	End if 
	
	If (fl_lDrawRoughLoad>0)
		If ($fl_lDrawArrow=kTrue)
			$fl_lX:=$fl_lPosWidth+fl_lHeaderWidth-14
			$fl_rY:=$fl_lPosHeigth+fl_lCellHeigth-14
			lf_ARROW_DRAW($fl_lRowIndex; $fl_lX+$fl_rArrowRightMove; $fl_rY+$fl_rArrowDownMove)  // draw open arrow at the bottom of cell
		End if 
		// draw cell 100% line and subarea
		fl_ROUGH_LOAD_DRAW(1; $fl_lRowIndex; $fl_lRowStart; $fl_lRowEnd; $fl_lPosWidth; $fl_lPosHeigth; $fl_lEnd)
		If (fl_afRowOpen{$fl_lRowIndex}=True:C214)
			$fl_lPosHeigth:=$fl_lPosHeigth+fl_alSubHeigth{$fl_lRowIndex}
		End if 
		$fl_lPosHeigth:=$fl_lPosHeigth+fl_lCellHeigth
	End if 
	
	If (fl_lDailyLoad=2)
		If ($fl_lDrawArrow=kTrue)
			$fl_lX:=$fl_lPosWidth+fl_lHeaderWidth-14
			$fl_rY:=$fl_lPosHeigth+$fl_rTxtFromBorder+2
			lf_ARROW_DRAW($fl_lRowIndex; $fl_lX+$fl_rArrowRightMove; $fl_rY+$fl_rArrowDownMove)  // draw open arrow at the top of cell
		End if 
		//$fl_lPosHeigth:=$fl_lPosHeigth+$fl_rTxtFromBorder
		fl_START_STOP_CAP_DRAW($fl_lRowIndex; $fl_lPosWidth; $fl_lPosHeigth; $fl_lEnd; fl_dCurrentDate; fl_hCurrentTime)  // draw ldmp_ screen
		
		$fl_lPosHeigth:=$fl_lPosHeigth+fl_alSubHeigth{$fl_lRowIndex}
	End if 
	
End for 


ARRAY TEXT:C222(fl_atCurrentLoadGroup; 0)
ARRAY TEXT:C222(fl_atCurrentProdLotPhase; 0)
ARRAY LONGINT:C221(fl_alNumberOfOpenPhase; 0)

$fl_lPosWidth:=fl_lHeaderWidth
fl_pb_lRoundedX:=2
fl_pb_lRoundedY:=2
If (fl_lDrawRoughLoad>0)
	// draws cell bars in a loop
	fl_ROUGH_LOAD_DRAW(2; $fl_lRowIndex; $fl_lRowStart; $fl_lRowEnd; $fl_lPosWidth; $fl_lPosHeigth; $fl_lEnd)
End if 

// final drawings

// create select rect
$fl_tSelectRectRef:=SVG_New_rect(fl_tDrawRef; 0; 0; fl_lCellWidth; fl_lCellHeigth; 0; 0; "blue"; "none"; 2)
SVG_SET_ID($fl_tSelectRectRef; "fl_cell_select_rect")
SVG_SET_VISIBILITY($fl_tSelectRectRef; False:C215)

// create highlight rect

$fl_tSelectRectRef:=SVG_New_rect(fl_tDrawRef; 0; 0; fl_lCellWidth; fl_lCellHeigth; 0; 0; $fl_tHighlightColor; "none"; $fl_rHighlightLineWidth)
SVG_SET_ID($fl_tSelectRectRef; "fl_highlight_rect")
SVG_SET_VISIBILITY($fl_tSelectRectRef; False:C215)

$fl_lAreaWidth:=$fl_lAreaWidth+$fl_rCircleAreaWidth
$fl_rBorderWidth:=1
$fl_rOpenedHeigth:=$fl_lPosHeigth+1  //easier this way

If (fl_lHeaderHeigth>0)
	//top header line
	$fl_tObject:=SVG_New_line(fl_tDrawRef; 0; fl_lHeaderHeigth; $fl_lAreaWidth; fl_lHeaderHeigth; "black"; $fl_rBorderWidth)
End if 
If (fl_lHeaderWidth>0)
	//left header line
	$fl_tObject:=SVG_New_line(fl_tDrawRef; fl_lHeaderWidth; 0; fl_lHeaderWidth; $fl_rOpenedHeigth-($fl_rBorderWidth/2); "black"; $fl_rBorderWidth)
End if 
// right line
$fl_tObject:=SVG_New_line(fl_tDrawRef; $fl_lAreaWidth; 0; $fl_lAreaWidth; $fl_rOpenedHeigth-($fl_rBorderWidth/2); "black"; $fl_rBorderWidth)
// bottom line
$fl_tObject:=SVG_New_line(fl_tDrawRef; 0; $fl_rOpenedHeigth; $fl_lAreaWidth; $fl_rOpenedHeigth; "black"; $fl_rBorderWidth)


fl_TIP_TEXT_DRAW  // this must be last draw or yellow tip text will be under something else

// clear extra below area (too long lines if bottom line is very thin like 0,25 px)
//$fl_tObject:=SVG_New_rect (fl_tDrawRef;0;$fl_rOpenedHeigth-0,75;$fl_lAreaWidth+2;2;0;0;"none";fl_pb_tBackgroundColorNone;0)
$fl_rOpenedHeigth:=$fl_rOpenedHeigth+$fl_rBorderWidth
fl_lViewBoxWidth:=$fl_lAreaWidth+4
fl_lViewBoxHeigth:=$fl_rOpenedHeigth
If (($fl_lHeigth-4)>fl_lViewBoxHeigth)
	fl_lViewBoxHeigth:=$fl_lHeigth-4  // -4 for extra, prevent scrollbar
End if 
SVG_SET_VIEWBOX(fl_tDrawRef; 0; 0; fl_lViewBoxWidth; fl_lViewBoxHeigth; "none")  // +4 to show frim time "24" some part of "4" and show drawing errors


fl_SVG_UPDATE
fl_pb_lRoundedX:=$fl_pb_lRoundedX
fl_pb_lRoundedY:=$fl_pb_lRoundedY
//$ldro_tSvgErrorHandler:=SVG_Set_error_handler ($ldro_tSvgErrorHandler)  // result is prev err handler method
SET CURSOR:C469(kCursorNormal)

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 